<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://powerfulwp.com/
 * @since      1.0.0
 *
 * @package    Aafw
 * @subpackage Aafw/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Aafw
 * @subpackage Aafw/admin
 * @author     powerfulwp <apowerfulwp@gmail.com>
 */
class Aafw_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string $plugin_name       The name of this plugin.
	 * @param      string $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version     = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Aafw_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Aafw_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		$screen = get_current_screen();
		if ( 'toplevel_page_aafw-settings' === $screen->base ){
			wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/aafw-admin.css', array(), $this->version, 'all' );
			wp_enqueue_style( 'aafw_chosen_css', plugin_dir_url( __FILE__ ) . 'css/chosen.min.css', array(), $this->version, 'all' );
		}

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Aafw_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Aafw_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		$screen = get_current_screen();
		if ( 'toplevel_page_aafw-settings' === $screen->base ){
			wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/aafw-admin.js', array( 'jquery' ), $this->version, false );
			wp_enqueue_script( 'aafw_chosen_js', plugin_dir_url( __FILE__ ) . 'js/chosen.jquery.min.js', array( 'jquery' ), $this->version, false );
		}

	}

	/**
	 * Plugin submenu.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function admin_menu() {
		// add menu to main menu.
		 add_menu_page( esc_html( __( 'Autocomplete Address Settings', 'aafw' ) ), esc_html( __( 'Autocomplete Address', 'lddfw' ) ), 'edit_pages', 'aafw-settings', array( &$this, 'settings' ), 'dashicons-location-alt', 56 );
		 add_submenu_page( 'aafw-settings', esc_html( __( 'Settings', 'aafw' ) ), esc_html( __( 'Settings', 'lddfw' ) ), 'edit_pages', 'aafw-settings', array( &$this, 'settings' ) );
	}

	/**
	 * Plugin settings.
	 *
	 * @since 1.0.0
	 */
	public function settings() {

		// Default variables.
		$settings_title = esc_html( __( 'General Settings', 'aafw' ) );

		// Get the current tab from the $_GET param.
		$current_tab = isset( $_GET['tab'] ) ? sanitize_text_field( wp_unslash( $_GET['tab'] ) ) : '';

		 // Tabs array.
		 $tabs = array(
			 array(
				 'slug'  => '',
				 'label' => esc_html( __( 'General settings', 'aafw' ) ),
				 'title' => esc_html( __( 'General settings', 'aafw' ) ),
				 'url'   => '?page=aafw-settings',
			 ),
		 );

		 foreach ( $tabs as $tab ) {
			 if ( $current_tab === $tab['slug'] ) {
				 $settings_title = $tab['title'];
				 break;
			 }
		 }
		echo aafw_admin_plugin_bar();
			?>
		<div class="wrap">
		<form action='options.php' method='post'>
			<h1 class="wp-heading-inline"><?php echo esc_html( $settings_title ); ?></h1>
			<?php

			if ( 1 < count( $tabs ) ) {
				?>
							<nav class="nav-tab-wrapper">
						<?php
						foreach ( $tabs as $tab ) {
							$url = ( '' !== $tab['slug'] ) ? 'admin.php?page=aafw-settings&tab=' . esc_attr( $tab['slug'] ) : 'admin.php?page=aafw-settings';
							echo '<a href="' . esc_html( admin_url( $url ) ) . '" class="nav-tab ' . ( $current_tab === $tab['slug'] ? 'nav-tab-active' : '' ) . '">' . esc_html( $tab['label'] ) . '</a>';
						}
						?>
							</nav>
						<?php
			}

				echo '<hr class="wp-header-end">';

			foreach ( $tabs as $tab ) {
				if ( '' === $current_tab ) {
					settings_fields( 'aafw' );
					do_settings_sections( 'aafw' );
					break;
				} elseif ( $current_tab === $tab['slug'] ) {
					settings_fields( $tab['slug'] );
					do_settings_sections( $tab['slug'] );
					break;
				}
			}

				submit_button();
			?>
		</form>
	</div>
		<?php
	}
	/**
	 * Plugin register settings.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function settings_init() {

		// Get settings tab.
		$tab = isset( $_GET['tab'] ) ? sanitize_text_field( wp_unslash( $_GET['tab'] ) ) : '';
		register_setting( 'aafw', 'aafw_google_api_key' );
		register_setting( 'aafw', 'aafw_shipping_autocomplete' );
		register_setting( 'aafw', 'aafw_billing_autocomplete' );
		register_setting( 'aafw', 'aafw_initial_map' );

		if ( aafw_fs()->is__premium_only() ) {
			if ( aafw_fs()->can_use_premium_code() ) {
				register_setting( 'aafw', 'aafw_map_position' );
				register_setting( 'aafw', 'aafw_center_map_latitude' );
				register_setting( 'aafw', 'aafw_center_map_longitude' );
				register_setting( 'aafw', 'aafw_restrictions' );
				register_setting( 'aafw', 'aafw_location_picker' );
				register_setting( 'aafw', 'aafw_location_picker_type' );
				register_setting( 'aafw', 'aafw_customer_location' );
				register_setting( 'aafw', 'aafw_coordinates' );
				register_setting( 'aafw', 'aafw_map_zoom' );
				register_setting( 'aafw', 'aafw_customer_location_auto_select' );
			}
		}

		if ( '' === $tab ) {

			// General Settings.
			add_settings_section(
				'aafw_setting_section',
				'',
				'',
				'aafw'
			);

			add_settings_field(
				'aafw_google_api_key',
				__( 'Google API key', 'aafw' ),
				array( $this, 'google_api_key' ),
				'aafw',
				'aafw_setting_section'
			);

			add_settings_field(
				'aafw_billing_autocomplete',
				__( 'Billing address', 'aafw' ),
				array( $this, 'aafw_billing_autocomplete' ),
				'aafw',
				'aafw_setting_section'
			);
			add_settings_field(
				'aafw_shipping_autocomplete',
				__( 'Shipping address', 'aafw' ),
				array( $this, 'aafw_shipping_autocomplete' ),
				'aafw',
				'aafw_setting_section'
			);
			add_settings_field(
				'aafw_restrictions',
				__( 'Country restrictions', 'aafw' ),
				array( $this, 'aafw_restrictions' ),
				'aafw',
				'aafw_setting_section'
			);
			add_settings_field(
				'aafw_initial_map',
				__( 'Map', 'aafw' ),
				array( $this, 'aafw_initial_map' ),
				'aafw',
				'aafw_setting_section'
			);

			add_settings_field(
				'aafw_map_zoom',
				__( 'Map zoom', 'aafw' ),
				array( $this, 'aafw_map_zoom' ),
				'aafw',
				'aafw_setting_section'
			);

			add_settings_field(
				'aafw_center_map',
				__( 'Center map', 'aafw' ),
				array( $this, 'aafw_center_map' ),
				'aafw',
				'aafw_setting_section'
			);

			add_settings_field(
				'aafw_map_position',
				__( 'Map position on the page', 'aafw' ),
				array( $this, 'aafw_map_position' ),
				'aafw',
				'aafw_setting_section'
			);


			add_settings_field(
				'aafw_location_picker',
				__( 'Location Picker', 'aafw' ),
				array( $this, 'aafw_location_picker' ),
				'aafw',
				'aafw_setting_section'
			);

			add_settings_field(
				'aafw_location_picker_type',
				__( 'Location Picker update options', 'aafw' ),
				array( $this, 'aafw_location_picker_type' ),
				'aafw',
				'aafw_setting_section'
			);
			

			add_settings_field(
				'aafw_coordinates',
				__( 'Coordinates', 'aafw' ),
				array( $this, 'aafw_coordinates' ),
				'aafw',
				'aafw_setting_section'
			);

			add_settings_field(
				'aafw_customer_location',
				__( 'Customer location', 'aafw' ),
				array( $this, 'aafw_customer_location' ),
				'aafw',
				'aafw_setting_section'
			);

		}

		do_action( 'aafw_settings' );
	}

	/**
	 * Plugin settings.
	 *
	 * @since 1.0.0
	 */
	public function google_api_key() {
		?>
		<p>
			<input type='text' class='regular-text' name='aafw_google_api_key' value='<?php echo esc_attr( get_option( 'aafw_google_api_key', '' ) ); ?>'><br>
			<span class="description" id="aafw-gooogle-api-key-description">
				<?php echo esc_html( __( 'Google Key for Places API, Maps JavaScript API, Maps Embed API, Geocoding API. ( Application restrictions: HTTP referrers )', 'aafw' ) ); ?>
				<br><?php echo sprintf( esc_html( __( 'For more information on how to create the Google API key %1$sclick here%2$s.', 'aafw' ) ),  '<a href="https://powerfulwp.com/docs/autocomplete-address-and-location-picker-for-woocommerce-premium/getting-started/general-settings/" target="_blank">', '</a>' ); ?>
			</span>
		</p>
		<?php
	}

	/**
	 * Plugin settings.
	 *
	 * @since 1.0.0
	 */
	public function aafw_billing_autocomplete() {
		?>
		<p>
			<input type='checkbox' class='regular-checkbox' name='aafw_billing_autocomplete'  <?php echo checked( '1', get_option( 'aafw_billing_autocomplete', '' ) ); ?> value='1' >
			 <?php echo esc_html( __( 'Enable autocomplete address for the billing address.', 'aafw' ) ); ?>
		</p>
		<?php
	}

	 /**
	  * Plugin settings.
	  *
	  * @since 1.0.0
	  */
	public function aafw_shipping_autocomplete() {
		?>
		<p>
			<input type='checkbox' class='regular-checkbox' name='aafw_shipping_autocomplete' <?php echo checked( '1', get_option( 'aafw_shipping_autocomplete', '' ) ); ?> value='1'>
			<?php echo esc_html( __( 'Enable autocomplete address for the shipping address.', 'aafw' ) ); ?>
		</p>
		<?php
	}


	 /**
	  * Plugin settings.
	  *
	  * @since 1.0.0
	  */
	public function aafw_location_picker() {
		$element = '';
		if ( aafw_fs()->is__premium_only() ) {
			if ( aafw_fs()->can_use_premium_code() ) {
				$element = '<input type="checkbox" class="regular-checkbox" name="aafw_location_picker" ' . checked( '1', get_option( 'aafw_location_picker', '' ), false ) . ' value="1">';
			}
		}
		?>
		<p>
			 <?php echo aafw_premium_feature( $element ); ?>
			 <?php echo esc_html( __( 'Enable location picker on the map. ( map to address )', 'aafw' ) ); ?>
		</p>
		<?php
	}

	 /**
	  * Plugin settings.
	  *
	  * @since 1.0.0
	  */
	  public function aafw_location_picker_type() {
			if ( aafw_fs()->is__premium_only() ) {
				if ( aafw_fs()->can_use_premium_code() ) {
					$aafw_location_picker_type = get_option( 'aafw_location_picker_type', '' );
					?>
						<select name="aafw_location_picker_type" >
							<?php
							echo '<option value="1" ' . esc_attr( wc_selected( '1', $aafw_location_picker_type ) ) . '>' . esc_html( __( 'Update address and location', 'aafw' ) ) . '</option>';
							echo '<option value="2" ' . esc_attr( wc_selected( '2', $aafw_location_picker_type ) ) . '>' . esc_html( __( 'Update only the location', 'aafw' ) ) . '</option>';
							echo '<option value="3" ' . esc_attr( wc_selected( '3', $aafw_location_picker_type ) ) . '>' . esc_html( __( 'Update address or/and location ( customer choice )', 'aafw' ) ) . '</option>';
							?>
						</select><br>
					<?php
				}
			}
		?>
		<p>
			 <?php echo aafw_premium_feature( '' ); ?>
			 <?php echo esc_html( __( 'Select which updates the location picker does. ( address or/and location coordinates ).', 'aafw' ) ); ?>
		</p>
		<?php
	}

	


	 /**
	  * Plugin settings.
	  *
	  * @since 1.0.0
	  */
	public function aafw_customer_location() {
		$element = '';
		if ( aafw_fs()->is__premium_only() ) {
			if ( aafw_fs()->can_use_premium_code() ) {
				$element = '<input type="checkbox" class="regular-checkbox" name="aafw_customer_location" ' . checked( '1', get_option( 'aafw_customer_location', '' ), false ) . ' value="1">';
			}
		}
		?>
		<p>
			<?php echo aafw_premium_feature( $element ); ?>
			<?php echo esc_html( __( 'Enable use of customer current location.', 'aafw' ) ); ?>
		</p>
		<?php
			if ( aafw_fs()->is__premium_only() ) {
				if ( aafw_fs()->can_use_premium_code() ) {
				   echo '<p>
							<input type="checkbox" class="regular-checkbox" name="aafw_customer_location_auto_select" ' . checked( '1', get_option( 'aafw_customer_location_auto_select', '' ), false ) . ' value="1">
							' . esc_html( __( 'Enable auto-select the customer\'s current location.', 'aafw' ) ) . '
						</p>';
				}
			}
		?>
		<?php
	}


	 /**
	  * Plugin settings.
	  *
	  * @since 1.0.0
	  */
	public function aafw_coordinates() {
		$element = '';
		if ( aafw_fs()->is__premium_only() ) {
			if ( aafw_fs()->can_use_premium_code() ) {
				$element = '<input type="checkbox" class="regular-checkbox" name="aafw_coordinates" ' . checked( '1', get_option( 'aafw_coordinates', '' ), false ) . ' value="1">';
			}
		}
		?>
		<p>
			 <?php echo aafw_premium_feature( $element ); ?>
			 <?php echo esc_html( __( 'Enable adding latitude and longitude to order with a link to show on the map.', 'aafw' ) ); ?>
		</p>
		<?php
	}

	/**
	  * Plugin settings.
	  *
	  * @since 1.0.0
	  */
	  public function aafw_map_zoom() {
		?>
			<p>
				<?php
					if ( aafw_fs()->is__premium_only() ) {
						if ( aafw_fs()->can_use_premium_code() ) {
							$aafw_map_zoom = get_option( 'aafw_map_zoom', '' );
							$aafw_map_zoom = ( '' !== $aafw_map_zoom ) ? $aafw_map_zoom : 11 ;
							?>
								<select name="aafw_map_zoom" >
									<?php
										for ($i = 0; $i <= 20; $i++) {
											echo '<option value="'.esc_attr( $i ).'" ' . esc_attr( wc_selected( $i , $aafw_map_zoom ) ) . '>' . esc_attr( $i ) . '</option>';
										}
									?>
								</select><br>
							<?php
						}
					}
				?>
				<span><?php echo aafw_premium_feature( "" ) ; ?></span>
			</p>
		<?php
	}

	 /**
	  * Plugin settings.
	  *
	  * @since 1.0.0
	  */
	  public function aafw_map_position() {
		?>
			<p>
				<?php
					if ( aafw_fs()->is__premium_only() ) {
						if ( aafw_fs()->can_use_premium_code() ) {
							$aafw_map_position = get_option( 'aafw_map_position', '' );
							?>
								<select name="aafw_map_position" >
									<?php
									echo '<option value="1" ' . esc_attr( wc_selected( '1', $aafw_map_position ) ) . '>' . esc_html( __( 'Show map after address fields', 'aafw' ) ) . '</option>';
									echo '<option value="2" ' . esc_attr( wc_selected( '2', $aafw_map_position ) ) . '>' . esc_html( __( 'Show map before address fields', 'aafw' ) ) . '</option>';
									?>
								</select><br>
							<?php
						}
					}
				?>
				<span><?php echo aafw_premium_feature( "" ) . esc_html( __( 'Choose where to show the map on the checkout page.', 'aafw' ) ); ?></span>
			</p>
		<?php
	}

	 /**
	  * Plugin settings.
	  *
	  * @since 1.0.0
	  */
	public function aafw_initial_map() {
		?>
			<label for="aafw_initial_map">
				<input type="checkbox" class="regular-checkbox" name="aafw_initial_map" <?php echo checked( '1', get_option( 'aafw_initial_map', '' ), false ) ?> value="1">
				<?php echo esc_html( __( 'Enable map.', 'aafw' ) ); ?>
			</label>
		<?php
	}

	 /**
	  * Plugin settings.
	  *
	  * @since 1.0.0
	  */
	public function aafw_center_map() {
		?>
			<p>
				<?php
					if ( aafw_fs()->is__premium_only() ) {
						if ( aafw_fs()->can_use_premium_code() ) {
							$aafw_center_map_latitude  = get_option( 'aafw_center_map_latitude', '' );
							$aafw_center_map_longitude = get_option( 'aafw_center_map_longitude', '' );
							?>
								<?php echo esc_html( __( 'Latitude', 'aafw' ) ); ?> <input type='text' class='medium-text' name='aafw_center_map_latitude' value='<?php echo esc_attr( $aafw_center_map_latitude ); ?>'>
								<?php echo esc_html( __( 'Longitude', 'aafw' ) ); ?> <input type='text' class='medium-text' name='aafw_center_map_longitude' value='<?php echo esc_attr( $aafw_center_map_longitude ); ?>'>
							<br>
							<?php
						}
					}
				?>
				<span><?php echo aafw_premium_feature( "" ) . sprintf( __( 'Enter latitude & longitude to center the map. You can find the coordinates of a place on <a target="_blank" href="%s">Google Maps</a>.', 'aafw' ), esc_url( 'https://maps.google.com/' ) ); ?></span>
			</p>
		<?php
	}



	 /**
	  * Plugin settings.
	  *
	  * @since 1.0.0
	  */
	public function aafw_restrictions() {
		?>
		<p>
		<?php
		if ( aafw_fs()->is__premium_only() ) {
			if ( aafw_fs()->can_use_premium_code() ) {
				$aafw_restrictions = get_option( 'aafw_restrictions', '' );
				$countries = WC()->countries->get_allowed_countries();
				?>
				<select multiple="multiple" name="aafw_restrictions[]" data-placeholder="<?php esc_attr_e( 'Select country restrictions', 'woocommerce' ); ?>" class="chosen_select">
					<?php
						foreach ( $countries as $country_key  => $country ) {
							echo '<option value="' . esc_attr( $country_key ) . '"' . esc_attr( wc_selected( $country_key, $aafw_restrictions ) ) . '>' . esc_html( esc_attr( $country ) ) . '</option>';
						}
					?>
				</select>
				<br>
				<?php
			}
		}
		?>
 			<span><?php echo aafw_premium_feature( "" ) . esc_html( __( 'Choose countries to limit the autocomplete search results, you can choose up to 5 countries.', 'aafw' ) ); ?></span>
		</p>
		<?php
	}

	/**
	 * Billing coordinates.
	 *
	 * @param object $order order.
	 * @return void
	 */
	public function admin_order_data_after_billing_address__premium_only( $order ) {
		$aafw_billing_coordinates = get_post_meta( $order->get_id(), 'aafw_billing_coordinates', true );
		$longitude                = '';
		$latitude                 = '';
		echo '<br class="clear" /> <div class="address">';
		if ( ! empty( $aafw_billing_coordinates ) ) {
			if ( ! empty( $aafw_billing_coordinates['latitude'] ) && ! empty( $aafw_billing_coordinates['longitude'] ) ) {
				$latitude  = esc_attr( $aafw_billing_coordinates['latitude'] );
				$longitude = esc_attr( $aafw_billing_coordinates['longitude'] );
				$link      = 'https://www.google.com/maps/search/?api=1&query=' . $latitude . ',' . $longitude;
				echo ' <b>' . esc_html( __( 'Latitude:', 'aafw' ) ) . '</b> <a href="' . esc_attr( $link ) . '" target="_blank">' . $latitude . '</a><br>';
				echo ' <b>' . esc_html( __( 'Longitude:', 'aafw' ) ) . '</b> <a href="' . esc_attr( $link ) . '" target="_blank">' . $longitude . '</a>';
			}
		}
		echo '</div><div class="edit_address">';
		woocommerce_wp_text_input(
			array(
				'id'            => 'aafw_billing_coordinates_latitude',
				'label'         => __( 'latitude', 'aafw' ),
				'value'         => $latitude,
				'wrapper_class' => 'form-field-wide',
			)
		);

		woocommerce_wp_text_input(
			array(
				'id'            => 'aafw_billing_coordinates_longitude',
				'label'         => __( 'longitude', 'aafw' ),
				'value'         => $longitude,
				'wrapper_class' => 'form-field-wide',
			)
		);

		echo '</div>';
	}

	/**
	 * Shipping coordinates.
	 *
	 * @since 1.0.0
	 */
	public function admin_order_data_after_shipping_address__premium_only( $order ) {
		$aafw_shipping_coordinates = get_post_meta( $order->get_id(), 'aafw_shipping_coordinates', true );
		$longitude                 = '';
		$latitude                  = '';
		echo '<br class="clear" /> <div class="address">';
		if ( ! empty( $aafw_shipping_coordinates ) ) {
			if ( ! empty( $aafw_shipping_coordinates['latitude'] ) && ! empty( $aafw_shipping_coordinates['longitude'] ) ) {
				$latitude  = esc_attr( $aafw_shipping_coordinates['latitude'] );
				$longitude = esc_attr( $aafw_shipping_coordinates['longitude'] );

				$link = 'https://www.google.com/maps/search/?api=1&query=' . $latitude . ',' . $longitude;
				echo ' <b>' . esc_html( __( 'Latitude:', 'aafw' ) ) . '</b> <a href="' . esc_attr( $link ) . '" target="_blank">' . $latitude . '</a><br>';
				echo ' <b>' . esc_html( __( 'Longitude:', 'aafw' ) ) . '</b> <a href="' . esc_attr( $link ) . '" target="_blank">' . $longitude . '</a>';
			}
		}
		echo '</div><div class="edit_address">';

		woocommerce_wp_text_input(
			array(
				'id'            => 'aafw_shipping_coordinates_latitude',
				'label'         => __( 'latitude', 'aafw' ),
				'value'         => $latitude,
				'wrapper_class' => 'form-field-wide',
			)
		);

		woocommerce_wp_text_input(
			array(
				'id'            => 'aafw_shipping_coordinates_longitude',
				'label'         => __( 'longitude', 'aafw' ),
				'value'         => $longitude,
				'wrapper_class' => 'form-field-wide',
			)
		);

		echo '</div>';

	}


	/**
	 * Process shop order meta.
	 *
	 * @since 1.0.0
	 */
	public function process_shop_order_meta__premium_only( $order_id ) {

			// Shipping coordinates.
			$shipping_lat         = isset( $_POST['aafw_shipping_coordinates_latitude'] ) ? sanitize_text_field( wp_unslash( $_POST['aafw_shipping_coordinates_latitude'] ) ) : '';
			$shipping_lng         = isset( $_POST['aafw_shipping_coordinates_longitude'] ) ? sanitize_text_field( wp_unslash( $_POST['aafw_shipping_coordinates_longitude'] ) ) : '';
			$shipping_coordinates = '';

		if ( '' !== $shipping_lat && '' !== $shipping_lng ) {
			$shipping_coordinates = array(
				'latitude'  => $shipping_lat,
				'longitude' => $shipping_lng,
			);
		}
			update_post_meta( $order_id, 'aafw_shipping_coordinates', $shipping_coordinates );

			// Billing coordinates.
			$billing_lat         = isset( $_POST['aafw_billing_coordinates_latitude'] ) ? sanitize_text_field( wp_unslash( $_POST['aafw_billing_coordinates_latitude'] ) ) : '';
			$billing_lng         = isset( $_POST['aafw_billing_coordinates_longitude'] ) ? sanitize_text_field( wp_unslash( $_POST['aafw_billing_coordinates_longitude'] ) ) : '';
			$billing_coordinates = '';

		if ( '' !== $billing_lat && '' !== $billing_lng ) {
			$billing_coordinates = array(
				'latitude'  => $billing_lat,
				'longitude' => $billing_lng,
			);
		}
			update_post_meta( $order_id, 'aafw_billing_coordinates', $billing_coordinates );

	}


	/**
	 * Coordinates filter.
	 *
	 * @since 1.0.0
	 */
	public function order_shipping_address_coordinates__premium_only( $order, $coordinates ) {
		$shipping_address_1 = $order->get_shipping_address_1();
		if ( '' !== $shipping_address_1 ) {
			$aafw_shipping_coordinates = get_post_meta( $order->get_id(), 'aafw_shipping_coordinates', true );
		} else {
			$aafw_shipping_coordinates = get_post_meta( $order->get_id(), 'aafw_billing_coordinates', true );
		}

		if ( ! empty( $aafw_shipping_coordinates ) ) {
			if ( ! empty( $aafw_shipping_coordinates['latitude'] ) && ! empty( $aafw_shipping_coordinates['longitude'] ) ) {
				 $coordinates = $aafw_shipping_coordinates['latitude'] . ',' . $aafw_shipping_coordinates['longitude'];
			}
		}
		return $coordinates;
	}


}
