<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://powerfulwp.com/
 * @since      1.0.0
 *
 * @package    Aafw
 * @subpackage Aafw/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Aafw
 * @subpackage Aafw/public
 * @author     powerfulwp <apowerfulwp@gmail.com>
 */
class Aafw_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Aafw_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Aafw_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		if ( is_checkout() ) {
			if ( true === AAFW_AUTOCOMPLETE ) {
				wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/aafw-public.css', array(), $this->version, 'all' );
			}
		}

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Aafw_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Aafw_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		// Check if is checkout page.
		if ( is_checkout() ) {
			if ( true === AAFW_AUTOCOMPLETE ) {

					$aafw_google_api_key 		= get_option( 'aafw_google_api_key', '' );
					$aafw_billing_autocomplete 	= get_option( 'aafw_billing_autocomplete', '' );
					$aafw_shipping_autocomplete = get_option( 'aafw_shipping_autocomplete', '' );
					$aafw_map 					= get_option( 'aafw_initial_map', '' );

					$aafw_restrictions 			= '';
					$aafw_location_picker		= '';
					$aafw_coordinates			= '';
					$aafw_customer_location 	= '';
					$aafw_center_map_latitude   = '';
					$aafw_center_map_longitude  = '';
					$aafw_location_picker_type  = '';
					$aafw_customer_location_auto_select = '';
					$aafw_map_zoom = '';

					if ( aafw_fs()->is__premium_only() ) {
						if ( aafw_fs()->can_use_premium_code() ) {
							$aafw_restrictions 			= get_option( 'aafw_restrictions', '' );
							$aafw_location_picker		= get_option( 'aafw_location_picker', '' );
							$aafw_coordinates			= get_option( 'aafw_coordinates', '' );
							$aafw_customer_location 	= get_option( 'aafw_customer_location', '' );
							$aafw_center_map_latitude   = get_option( 'aafw_center_map_latitude', '' );
							$aafw_center_map_longitude  = get_option( 'aafw_center_map_longitude', '' );
							$aafw_location_picker_type  = get_option( 'aafw_location_picker_type', '' );
							$aafw_map_zoom				= get_option( 'aafw_map_zoom', '' );
							$aafw_customer_location_auto_select = get_option( 'aafw_customer_location_auto_select', '' );
						}
					}

					// Set map zoom.
					$aafw_map_zoom = '' !== $aafw_map_zoom ? $aafw_map_zoom : 11;

					// Set center map coordinates.
					if ( ! is_numeric( $aafw_center_map_latitude ) || ! is_numeric( $aafw_center_map_longitude ) ){
						$aafw_center_map_latitude   = '40.730610';
						$aafw_center_map_longitude  = '-73.935242';
					}

					if ( '' !== $aafw_google_api_key ) {
						wp_enqueue_script( 'aafw-googleapis', 'https://maps.googleapis.com/maps/api/js?key=' . $aafw_google_api_key . '&libraries=places&v=weekly', array( 'jquery' ), $this->version, false );
					}

					wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/aafw-public.js', array( 'jquery' ), $this->version, false );
					wp_localize_script( $this->plugin_name, 'aafw_autocomplete',
					array( 'aafw_billing' => esc_js( $aafw_billing_autocomplete ),
					'aafw_shipping' => esc_js( $aafw_shipping_autocomplete ),
					'aafw_map' => esc_js( $aafw_map ),
					'aafw_restrictions' => $aafw_restrictions,
					'aafw_location_picker' => esc_js( $aafw_location_picker ),
					'aafw_coordinates' => esc_js( $aafw_coordinates ),
					'aafw_customer_location' => esc_js( $aafw_customer_location ),
					'aafw_select_address_text' => esc_js( __( 'Select address', 'aafw' ) ),
					'aafw_address_selected_text' => esc_js( __( 'Address selected', 'aafw' ) ),
					'aafw_center_map_latitude' => esc_js( $aafw_center_map_latitude ),
					'aafw_center_map_longitude' => esc_js( $aafw_center_map_longitude ),
					'aafw_location_picker_type' => esc_js( $aafw_location_picker_type ),
					'aafw_select_location_text' => esc_js( __( 'Select location', 'aafw' ) ),
					'aafw_location_selected_text' => esc_js( __( 'Location selected', 'aafw' ) ),
					'aafw_map_zoom' => esc_js( $aafw_map_zoom ),
					'aafw_customer_location_auto_select' => esc_js( $aafw_customer_location_auto_select ),
					) );
				}
		}
	}

	/**
	 * Billing map on checkout.
	 *
	 * @since     1.0.0
	 * @return    html    The billing map.
	 */
	public function billing_map( $checkout ) {
		$aafw_map = get_option( 'aafw_initial_map', '' );
		if ( '1' === $aafw_map ){
			echo '<div id="aafw_billing_map"></div>';
		}
		if ( aafw_fs()->is__premium_only() ) {
			if ( aafw_fs()->can_use_premium_code() ) {

				$aafw_coordinates = get_option( 'aafw_coordinates', '' );
				if ( '1' === $aafw_coordinates ){
					echo '<div class="aafw_coordinates">';
					if ( '1' === $aafw_map ){
						echo esc_html( __( "Location:" , 'aafw' ) ) . '<br> <span class="aafw_text_left">' . esc_html( __( "Latitude:" , 'aafw' ) ) . '<em id="aafw_billing_lat"></em></span><span>' . esc_html( __( "Longitude:" , 'aafw' ) ) . '<em id="aafw_billing_lng"></em></span>';
					}

					echo '<input type="hidden" id="aafw_billing_lng_input" name="aafw_billing_lng_input" value="">
						<input type="hidden" id="aafw_billing_lat_input" name="aafw_billing_lat_input" value="">
					</div>' ;
				}

			}
		}
	}

	/**
	 * Shipping map on checkout.
	 *
	 * @since     1.0.0
	 * @return    html    The billing map.
	 */
	public function shipping_map( $checkout ) {
		$aafw_map = get_option( 'aafw_initial_map', '' );
		if ( '1' === $aafw_map ){
			echo '<div id="aafw_shipping_map"></div>';
		}
		if ( aafw_fs()->is__premium_only() ) {
			if ( aafw_fs()->can_use_premium_code() ) {
				$aafw_coordinates = get_option( 'aafw_coordinates', '' );
				if ( '1' === $aafw_coordinates ){
					echo '<div class="aafw_coordinates">';
					if ( '1' === $aafw_map ){
						echo esc_html( __( "Location:" , 'aafw' ) ) . '<br> <span class="aafw_text_left">' . esc_html( __( "Latitude:" , 'aafw' ) ) . '<em id="aafw_shipping_lat"></em></span><span>' . esc_html( __( "Longitude:" , 'aafw' ) ) . '<em id="aafw_shipping_lng"></em></span>';
					}

					echo '<input type="hidden" id="aafw_shipping_lng_input" name="aafw_shipping_lng_input" value="">
							<input type="hidden" id="aafw_shipping_lat_input" name="aafw_shipping_lat_input" value="">
					</div>' ;
				}
			}
		}
	}

	/**
	 * Checkout function.
	 *
	 * @param number $order_id order number.
	 * @return void
	 */
	public function update_checkout_fields__premium_only( $order_id ) {
		$aafw_coordinates = get_option( 'aafw_coordinates', '' );
		if ( '1' === $aafw_coordinates && isset( $_POST['aafw_billing_lng_input'] ) ) {

			$shipping_lat = isset( $_POST['aafw_shipping_lat_input'] ) ? sanitize_text_field( wp_unslash( $_POST['aafw_shipping_lat_input'] ) ) : '';
			$shipping_lng = isset( $_POST['aafw_shipping_lng_input'] ) ? sanitize_text_field( wp_unslash( $_POST['aafw_shipping_lng_input'] ) ) : '';
			$billing_lat  = isset( $_POST['aafw_billing_lat_input'] )  ? sanitize_text_field( wp_unslash( $_POST['aafw_billing_lat_input'] ) )  : '';
			$billing_lng  = isset( $_POST['aafw_billing_lng_input'] )  ? sanitize_text_field( wp_unslash( $_POST['aafw_billing_lng_input'] ) )  : '';

			if ( empty( $_POST['ship_to_different_address'] ) || wc_ship_to_billing_address_only() ){
				$shipping_lat = $billing_lat;
				$shipping_lng = $billing_lng;
			}

			if ( '' !== $shipping_lat && '' !== $shipping_lng ) {
				update_post_meta( $order_id, 'aafw_shipping_coordinates', array(
					'latitude'	=> $shipping_lat,
					'longitude'	=> $shipping_lng,
				));
			}

			if ( '' !== $billing_lat && '' !== $billing_lng ) {
				update_post_meta( $order_id, 'aafw_billing_coordinates', array(
					'latitude'	=> $billing_lat,
					'longitude'	=> $billing_lng,
				));
			}

		}
	}

}
